/*
 * @(#)SeparatorLineFigure.java  1.0  2. Dezember 2003
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer.diagram;

import ch.hslu.cm.*;
import org.jhotdraw.draw.LineFigure;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.geom.Dimension2DDouble;

/**
 * A horizontal line with a preferred size of 1,1.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2. Dezember 2003  Created.
 */
public class SeparatorLineFigure 
extends LineFigure {
    
    /** Creates a new instance. */
    public SeparatorLineFigure() {
    }

    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        setPoint(0, 0, anchor);
        setPoint(getNodeCount() - 1, 0, new Point2D.Double(lead.x, anchor.y));
    }
    public Dimension2DDouble getPreferredSize() {
        double width = Math.ceil(STROKE_WIDTH.get(this));
        return new Dimension2DDouble(width, width);
    }
}
